<?php
// Exit if accessed directly
if( !defined('ABSPATH') ) exit;

/**
 * Misc Functions
 *
 * All misc functions handles to
 * different functions
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
/**
 * All Social Deals Networks
 *
 * Handles to return all social networks
 * names
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_slg_social_networks()
{

    $socialnetworks = array(
        'facebook' => esc_html__('Facebook', 'eddslg') ,
        'twitter' => esc_html__('Twitter', 'eddslg') ,
        'googleplus' => esc_html__('Google', 'eddslg') ,
        'linkedin' => esc_html__('LinkedIn', 'eddslg') ,
        'yahoo' => esc_html__('Yahoo', 'eddslg') ,
        'foursquare' => esc_html__('Foursquare', 'eddslg') ,
        'windowslive' => esc_html__('Windows Live', 'eddslg') ,
        'vk' => esc_html__('VK', 'eddslg') ,
        'amazon' => esc_html__('Amazon', 'eddslg') ,
        'paypal' => esc_html__('Paypal', 'eddslg') ,
        'apple' => esc_html__('Apple', 'eddslg') ,
    );
    return apply_filters('edd_slg_social_networks', $socialnetworks);
}

/**
 * Get Social Network Sorted List
 * as per saved in options
 *
 * Handles to return social networks sorted
 * array to list in page
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_slg_get_sorted_social_network()
{

    global $edd_options;

    $edd_social_order = get_option('edd_social_order');

    $socials = edd_slg_social_networks();

    if (!isset($edd_social_order) || empty($edd_social_order))
    {
        return $socials;
    }

    $sorted_socials = $edd_social_order;
    $return = array();

    for ($i = 0;$i < count($socials);$i++)
    {   
        if (!empty($sorted_socials[$i])) {
            $return[$sorted_socials[$i]] = $socials[$sorted_socials[$i]];
        }
    }

    if( !empty( $socials ) ){
        foreach ( $socials as $key => $value) {
            if( !in_array( $value, $return)){
                $return[$key] = $value;
            }
        }
    }
    return apply_filters('edd_slg_sorted_social_networks', $return);
}

/**
 * Initialize some needed variables
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_slg_initialize()
{

    global $edd_options;

    //facebook variable initialization
    $fb_app_id = isset($edd_options['edd_slg_fb_app_id']) ? $edd_options['edd_slg_fb_app_id'] : '';
    $fb_app_secret = isset($edd_options['edd_slg_fb_app_secret']) ? $edd_options['edd_slg_fb_app_secret'] : '';

    if (!defined('EDD_SLG_FB_APP_ID'))
    {
        define('EDD_SLG_FB_APP_ID', $fb_app_id);
    }
    if (!defined('EDD_SLG_FB_APP_SECRET'))
    {
        define('EDD_SLG_FB_APP_SECRET', $fb_app_secret);
    }

    //google+ variable initialization
    $gp_client_id = isset($edd_options['edd_slg_gp_client_id']) ? $edd_options['edd_slg_gp_client_id'] : '';

    if (!defined('EDD_SLG_GP_CLIENT_ID'))
    {
        define('EDD_SLG_GP_CLIENT_ID', $gp_client_id);
    }

    if (!defined('EDD_SLG_GP_REDIRECT_URL'))
    {
        $ssl = "http://";
        if (is_ssl())
        {
            $ssl = "https://";
        }
        $host = isset( $_SERVER["HTTP_HOST"] ) ? $_SERVER["HTTP_HOST"] : '';
        $googleurl = $ssl . $host;
        define('EDD_SLG_GP_REDIRECT_URL', $googleurl);
    }

    if (!defined('EDD_SLG_FB_REDIRECT_URL'))
    {
        $facebookurl = add_query_arg('eddslg', 'facebook', site_url());
        define('EDD_SLG_FB_REDIRECT_URL', $facebookurl);
    }

    //linkedin variable initialization
    $li_app_id = isset($edd_options['edd_slg_li_app_id']) ? $edd_options['edd_slg_li_app_id'] : '';
    $li_app_secret = isset($edd_options['edd_slg_li_app_secret']) ? $edd_options['edd_slg_li_app_secret'] : '';

    if (!defined('EDD_SLG_LI_APP_ID'))
    {
        define('EDD_SLG_LI_APP_ID', $li_app_id);
    }
    if (!defined('EDD_SLG_LI_APP_SECRET'))
    {
        define('EDD_SLG_LI_APP_SECRET', $li_app_secret);
    }
    if (!defined('EDD_SLG_LI_REDIRECT_URL'))
    {
        $linkedinurl = add_query_arg('eddslg', 'linkedin', trailingslashit(site_url()));
        define('EDD_SLG_LI_REDIRECT_URL', $linkedinurl);
    }
    // For LinkedIn Port http / https
    if (!defined('LINKEDIN_PORT_HTTP'))
    { //http port value
        define('LINKEDIN_PORT_HTTP', '80');
    }
    if (!defined('LINKEDIN_PORT_HTTP_SSL'))
    { //ssl port value
        define('LINKEDIN_PORT_HTTP_SSL', '443');
    }

    //twitter variable initialization
    $tw_consumer_key = isset($edd_options['edd_slg_tw_consumer_key']) ? $edd_options['edd_slg_tw_consumer_key'] : '';
    $tw_consumer_secrets = isset($edd_options['edd_slg_tw_consumer_secret']) ? $edd_options['edd_slg_tw_consumer_secret'] : '';

    if (!defined('EDD_SLG_TW_CONSUMER_KEY'))
    {
        define('EDD_SLG_TW_CONSUMER_KEY', $tw_consumer_key);
    }
    if (!defined('EDD_SLG_TW_CONSUMER_SECRET'))
    {
        define('EDD_SLG_TW_CONSUMER_SECRET', $tw_consumer_secrets);
    }

    //yahoo variable initialization
    $yh_consumer_key = isset($edd_options['edd_slg_yh_consumer_key']) ? $edd_options['edd_slg_yh_consumer_key'] : '';
    $yh_consumer_secret = isset($edd_options['edd_slg_yh_consumer_secret']) ? $edd_options['edd_slg_yh_consumer_secret'] : '';

    if (!defined('EDD_SLG_YH_CONSUMER_KEY'))
    {
        define('EDD_SLG_YH_CONSUMER_KEY', $yh_consumer_key);
    }
    if (!defined('EDD_SLG_YH_CONSUMER_SECRET'))
    {
        define('EDD_SLG_YH_CONSUMER_SECRET', $yh_consumer_secret);
    }
    if (!defined('EDD_SLG_YH_REDIRECT_URL'))
    {
        $yahoourl = site_url("/");
        define('EDD_SLG_YH_REDIRECT_URL', $yahoourl);
    }

    //foursquare variable initialization
    $fs_client_id = isset($edd_options['edd_slg_fs_client_id']) ? $edd_options['edd_slg_fs_client_id'] : '';
    $fs_client_secrets = isset($edd_options['edd_slg_fs_client_secret']) ? $edd_options['edd_slg_fs_client_secret'] : '';

    if (!defined('EDD_SLG_FS_CLIENT_ID'))
    {
        define('EDD_SLG_FS_CLIENT_ID', $fs_client_id);
    }
    if (!defined('EDD_SLG_FS_CLIENT_SECRET'))
    {
        define('EDD_SLG_FS_CLIENT_SECRET', $fs_client_secrets);
    }
    if (!defined('EDD_SLG_FS_REDIRECT_URL'))
    {
        $fsredirecturl = add_query_arg('eddslg', 'foursquare', site_url());
        define('EDD_SLG_FS_REDIRECT_URL', $fsredirecturl);
    }

    //windows live variable initialization
    $wl_client_id = isset($edd_options['edd_slg_wl_client_id']) ? $edd_options['edd_slg_wl_client_id'] : '';
    $wl_client_secrets = isset($edd_options['edd_slg_wl_client_secret']) ? $edd_options['edd_slg_wl_client_secret'] : '';

    if (!defined('EDD_SLG_WL_CLIENT_ID'))
    {
        define('EDD_SLG_WL_CLIENT_ID', $wl_client_id);
    }
    if (!defined('EDD_SLG_WL_CLIENT_SECRET'))
    {
        define('EDD_SLG_WL_CLIENT_SECRET', $wl_client_secrets);
    }
    if (!defined('EDD_SLG_WL_REDIRECT_URL'))
    {
        $wlredirecturl = add_query_arg('eddslg', 'windowslive', site_url());
        define('EDD_SLG_WL_REDIRECT_URL', $wlredirecturl);
    }

    //vk variable initialization
    $vk_client_id = isset($edd_options['edd_slg_vk_app_id']) ? $edd_options['edd_slg_vk_app_id'] : '';
    $vk_client_secrets = isset($edd_options['edd_slg_vk_app_secret']) ? $edd_options['edd_slg_vk_app_secret'] : '';

    if (!defined('EDD_SLG_VK_APP_ID'))
    {
        define('EDD_SLG_VK_APP_ID', $vk_client_id);
    }
    if (!defined('EDD_SLG_VK_APP_SECRET'))
    {
        define('EDD_SLG_VK_APP_SECRET', $vk_client_secrets);
    }
    if (!defined('EDD_SLG_VK_REDIRECT_URL'))
    {
        $vkredirecturl = add_query_arg('eddslg', 'vk', site_url('/'));
        define('EDD_SLG_VK_REDIRECT_URL', $vkredirecturl);
    }

    if (!defined('EDD_SLG_VK_LINK'))
    { // define vk variable for link
        $vk_link = 'https://vk.com';
        define('EDD_SLG_VK_LINK', $vk_link);
    }


    //Amazon variable initialization
    $amazon_client_id = isset($edd_options['edd_slg_amazon_app_id']) ? $edd_options['edd_slg_amazon_app_id'] : '';
    $amazon_client_secrets = isset($edd_options['edd_slg_amazon_app_secret']) ? $edd_options['edd_slg_amazon_app_secret'] : '';
    if (!defined('EDD_SLG_AMAZON_APP_ID'))
    {
        define('EDD_SLG_AMAZON_APP_ID', $amazon_client_id);
    }
    if (!defined('EDD_SLG_AMAZON_APP_SECRET'))
    {
        define('EDD_SLG_AMAZON_APP_SECRET', $amazon_client_secrets);
    }
    if (!defined('EDD_SLG_AMAZON_REDIRECT_URL'))
    {
        $amazonredirecturl = add_query_arg('eddslg', 'amazon', site_url());
        define('EDD_SLG_AMAZON_REDIRECT_URL', $amazonredirecturl);
    }

    //Payapl variable initialization
    $paypal_client_id = isset($edd_options['edd_slg_paypal_app_id']) ? $edd_options['edd_slg_paypal_app_id'] : '';
    $paypal_client_secrets = isset($edd_options['edd_slg_paypal_app_secret']) ? $edd_options['edd_slg_paypal_app_secret'] : '';
    $paypal_environment = isset($edd_options['edd_slg_paypal_environment']) ? $edd_options['edd_slg_paypal_environment'] : 'sandbox';

    if (!defined('EDD_SLG_PAYPAL_APP_ID'))
    {
        define('EDD_SLG_PAYPAL_APP_ID', $paypal_client_id);
    }
    if (!defined('EDD_SLG_PAYPAL_APP_SECRET'))
    {
        define('EDD_SLG_PAYPAL_APP_SECRET', $paypal_client_secrets);
    }
    if (!defined('EDD_SLG_PAYPAL_REDIRECT_URL'))
    {
        $paypalredirecturl = add_query_arg('eddslg', 'paypal', site_url());
        define('EDD_SLG_PAYPAL_REDIRECT_URL', $paypalredirecturl);
    }
    if (!defined('EDD_SLG_PAYPAL_ENVIRONMENT'))
    {
        define('EDD_SLG_PAYPAL_ENVIRONMENT', $paypal_environment);
    }

    //Apple Variable Initialization
    $apple_client_id = isset($edd_options['edd_slg_apple_client_id']) ? $edd_options['edd_slg_apple_client_id'] : '';
    if (!defined('EDD_SLG_APPLE_CLIENT_ID'))
    {
        define('EDD_SLG_APPLE_CLIENT_ID', $apple_client_id);
    }

    if (!defined('EDD_SLG_APPLE_REDIRECT_URL'))
    {
        $appleredirecturl = add_query_arg('eddslg', 'apple', site_url());
        define('EDD_SLG_APPLE_REDIRECT_URL', $appleredirecturl);
    }

}

/**
 * Checkout Page URL
 *
 * Handles to return checkout page url
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_slg_send_on_checkout_page($queryarg = array())
{

    global $edd_options;

    $sendcheckout = get_permalink($edd_options['purchase_page']);
    $sendcheckouturl = add_query_arg($queryarg, $sendcheckout);
    $sendcheckouturl = edd_slg_add_no_cache_param($sendcheckouturl);

    wp_redirect(apply_filters('edd_slg_checkout_page_redirect', $sendcheckouturl, $queryarg));
    exit;
}

/**
 * Check Any One Social Media
 * Login is enable or not
 *
 * Handles to Check any one social
 * media login is enable or not
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_slg_check_social_enable()
{

    global $edd_options;

    $return = false;

    //check if any social is activated or not
    if (!empty($edd_options['edd_slg_enable_facebook']) || !empty($edd_options['edd_slg_enable_googleplus']) || !empty($edd_options['edd_slg_enable_linkedin']) || !empty($edd_options['edd_slg_enable_twitter']) || !empty($edd_options['edd_slg_enable_yahoo']) || !empty($edd_options['edd_slg_enable_windowslive']) || !empty($edd_options['edd_slg_enable_vk']) || !empty($edd_options['edd_slg_enable_amazon']) || !empty($edd_options['edd_slg_enable_paypal']) || !empty($edd_options['edd_slg_enable_apple']))
    {
        $return = true;

    }

    return apply_filters('edd_slg_check_social_enable', $return);
}

/**
 * Facebook Redirect URL
 *
 * Handle to display Facebook redirect url description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_fb_redirect_url_callback($args)
{

    echo '<code><strong>' . EDD_SLG_FB_REDIRECT_URL . '</strong></code>';
}

/**
 * Google Redirect URL
 *
 * Handle to display google redirect url description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_gp_redirect_url_callback($args)
{

    echo '<code><strong>' . EDD_SLG_GP_REDIRECT_URL . '</strong></code>';
}

/**
 * Google Redirect URL Notice
 *
 * Handle to display google redirect url description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_gp_redirect_url_notice_callback($args)
{

    echo '<p class="edd-slg-gp-notice">Note: Before using the Google Plus social login, update the <strong>Authorized JavaScript origins</strong> in Google App setting, as mentioned in the document <a href="https://docs.wpwebelite.com/social-network-integration/google/#google-javascript-origins" target="_blank">here</a>.</p>';
}

/**
 * Linkedin Redirect URL
 *
 * Handle to display linkedin redirect url description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_li_redirect_url_callback($args)
{

    echo '<code><strong>' . EDD_SLG_LI_REDIRECT_URL . '</strong></code>';
}

/**
 * Yahoo Redirect URL
 *
 * Handle to display yahoo redirect url description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_yh_redirect_url_callback($args)
{

    echo '<code><strong>' . EDD_SLG_YH_REDIRECT_URL . '</strong></code>';
}

/**
 * Windows Live Redirect URL
 *
 * Handle to display windows live redirect url description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_wl_redirect_url_callback($args)
{

    echo '<code><strong>' . site_url() . '</strong></code>';
}

/**
 * VK Redirect URL
 *
 * Handle to display vk redirect url description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.3.0
 */
function edd_vk_redirect_url_callback($args)
{

    echo '<code><strong>' . EDD_SLG_VK_REDIRECT_URL . '</strong></code>';
}


/**
 * Facebook Description
 *
 * Handle to display facebook description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_facebook_desc_callback($args)
{ ?>
		
		<p><?php
    printf(esc_html__('Before you can start using Facebook for the social login, you need to create a Facebook Application. You can get a step by step tutorial on how to create Facebook Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/facebook/" target="_blank">', '</a>'); ?>
		</p><?php
}

/**
 * Reset Button
 *
 * Handle to display reset settings button
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.5.3
 */
function edd_social_reset_callback($args)
{

    global $edd_options;

    $button_value = isset($args['button']) && !empty($args['button']) ? $args['button'] : esc_html__('Reset Settings', 'eddslg');
    $social_reset_url = add_query_arg(array(
        'edd_slg_reset' => 'reset_settings'
    ) , get_permalink());

    $html = '';
    $reset_mesassage = esc_html__('Are you sure you want to reset social login setting?', 'eddslg');
    $html .= '<a onclick="return confirm(\'' . $reset_mesassage . '\')" href="' . $social_reset_url . '" class="edd-slg-reset-settings ' . $args['size'] . '" id="edd_settings[' . $args['id'] . ']" >' . $button_value . '</a>';
    $html .= $args['desc'];

    echo $html;
}

/**
 * Google+ Description
 *
 * Handle to display google+ description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_googleplus_desc_callback($args)
{ ?>
		
		<p><?php
    printf(esc_html__('Before you can start using Google for the social login, you need to create a Google Application. You can get a step by step tutorial on how to create Google Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/google/" target="_blank">', '</a>'); ?>
		</p><?php
}

/**
 * LinkedIn Description
 *
 * Handle to display linkedin description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_linkedin_desc_callback($args)
{ ?>
		
		<p><?php
    printf(esc_html__('Before you can start using LinkedIn for the social login, you need to create a LinkedIn Application. You can get a step by step tutorial on how to create LinkedIn Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/linkedin/" target="_blank">', '</a>'); ?>
		</p><?php
}

/**
 * Twitter Description
 *
 * Handle to display twitter description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_twitter_desc_callback($args)
{ ?>
		
		<p><?php
    printf(esc_html__('Before you can start using Twitter for the social login, you need to create a Twitter Application. You can get a step by step tutorial on how to create Twitter Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/twitter/" target="_blank">', '</a>'); ?>
		</p><?php
}

/**
 * Yahoo Description
 *
 * Handle to display yahoo description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_yahoo_desc_callback($args)
{ ?>
		
		<p><?php
    printf(esc_html__('Before you can start using Yahoo for the social login, you need to create a Yahoo Application. You can get a step by step tutorial on how to create Yahoo Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/yahoo/" target="_blank">', '</a>'); ?>
		</p><?php
}

/**
 * Foursquare Description
 *
 * Handle to display foursquare description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_foursquare_desc_callback($args)
{ ?>
		<p><?php
    printf(esc_html__('Before you can start using Foursquare for the social login, you need to create a Foursquare Application. You can get a step by step tutorial on how to create Foursquare Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/foursquare/" target="_blank">', '</a>'); ?>
		</p><?php
}

/**
 * Windows Live Description
 *
 * Handle to display windowslive description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_windowslive_desc_callback($args)
{ ?>
		
		<p><?php
    printf(esc_html__('Before you can start using Windows Live for the social login, you need to create a Windows Live Application. You can get a step by step tutorial on how to create Windows Live Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/windows_live/" target="_blank">', '</a>'); ?>
		</p><?php
}

/**
 * VK Description
 *
 * Handle to display vk description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.3.0
 */
function edd_vk_desc_callback($args)
{ ?>
		
		<p><?php
    printf(esc_html__('Before you can start using VK for the social login, you need to create a VK Application. You can get a step by step tutorial on how to create VK Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/vk/" target="_blank">', '</a>'); ?>
		</p><?php
}


/**
 * Amazon Description
 *
 * Handle to display amazon description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.7.0
 */
function edd_amazon_desc_callback($args)
{ ?>
		
		<p><?php
    printf(esc_html__('Before you can start using Amazon for the social login, you need to create a Amazon Application. You can get a step by step tutorial on how to create Amazon Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/amazon/" target="_blank">', '</a>'); ?>
		</p><?php
}

/**
 * Amazon Redirect URL
 *
 * Handle to display amazon redirect url description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.7.0
 */
function edd_amazon_redirect_url_callback($args)
{

    echo '<code><strong>' . EDD_SLG_AMAZON_REDIRECT_URL . '</strong></code>';
}

/**
 * Paypal Description
 *
 * Handle to display paypal description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.7.0
 */
function edd_paypal_desc_callback($args)
{ ?>
		
				<p><?php
    printf(esc_html__('Before you can start using Paypal for the social login, you need to create a Paypal Application. You can get a step by step tutorial on how to create Paypal Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/paypal/" target="_blank">', '</a>'); ?>
				</p><?php
}

/**
 * Apple Description
 *
 * Handle to display apple description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 2.2.10
 */

function edd_apple_desc_callback($args)
{ ?>
				<p><?php
    printf(esc_html__('	Before you can start using Apple for the social login, you need to create a Apple Application. You can get a step by step tutorial on how to create Apple Application on our %sDocumentation%s.', 'eddslg') , '<a href="https://docs.wpwebelite.com/social-network-integration/apple/" target="_blank">', '</a>'); ?>
				</p><?php
}

/**
 * Amazon Redirect URL
 *
 * Handle to display amazon redirect url description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.7.0
 */
function edd_paypal_redirect_url_callback($args)
{

    echo '<code><strong>' . EDD_SLG_PAYPAL_REDIRECT_URL . '</strong></code>';
}

/**
 * Amazon Redirect URL
 *
 * Handle to display amazon redirect url description in settings
 *
 * @package Easy Digital Downloads - Social Login
 * @since 2.2.10
 */

function edd_apple_redirect_url_callback($args)
{

    echo '<code><strong>' . EDD_SLG_APPLE_REDIRECT_URL . '</strong></code>';

}

/**
 * Current Page URL
 *
 * @package  Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
function edd_slg_get_current_page_url()
{

    $curent_page_url = remove_query_arg(array(
        'oauth_token',
        'oauth_verifier'
    ) , edd_get_current_page_url());
    return $curent_page_url;
}

/**
 * Get Easy Digital Downloads Screen ID
 *
 * Handles to get edd screen id
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.5.5
 */
function edd_slg_get_edd_screen_id()
{

    $edd_screen_id = 'download';
    return apply_filters('edd_slg_get_edd_screen_id', $edd_screen_id);
}

/**
 * Can Show Social Link
 *
 * Handles to check this social link can show or not
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.5.6
 */
function edd_slg_can_show_social_link($social = '')
{

    global $current_user;

    $display = false;

    //user id not found
    $user_id = isset($current_user->ID) ? $current_user->ID : '';

    if (!empty($user_id))
    {

        //get primary social api
        $primary_social = get_user_meta($user_id, 'edd_slg_social_user_connect_via', true);

        //get currunt social api meta
        $social_profile = get_user_meta($user_id, 'edd_slg_social_' . $social . '_data', true);

        // check  current provider is linked or not
        if (!$social_profile && $primary_social != $social)
        {

            $display = true;
        }
    }

    return apply_filters('edd_slg_can_display_social_link', $display, $social);
}

/**
 * Can Show Social Link Container
 *
 * Handles to check this social link can show or not
 *
 * @package Easy Digital Download - Social Login
 * @since 1.5.6
 */
function edd_slg_can_show_all_social_link_container()
{

    global $current_user, $edd_options;

    $display = false;

    //user id not found
    $user_id = isset($current_user->ID) ? $current_user->ID : '';

    if (!empty($user_id))
    { // if user is not empty
        //get all social api in order
        $edd_social_order = get_option('edd_social_order');

        if (!empty($edd_social_order))
        {

            //profile already linked as primary account
            $primary_social = get_user_meta($user_id, 'edd_slg_social_user_connect_via', true);

            foreach ($edd_social_order as $social)
            {

                //profile already linked as secondary account
                $social_profile = get_user_meta($user_id, 'edd_slg_social_' . $social . '_data', true);

                //if enable social account
                $enable_social = (!empty($edd_options['edd_slg_enable_' . $social])) ? true : false;
                
                if (!$social_profile && $primary_social != $social && $enable_social)
                {
                    $display = true;
                    break;
                }
            }
        }
    }

    return apply_filters('edd_slg_can_show_all_social_link_container', $display);
}

/**
 * Update Last Login Social Account
 *
 * Handles to update last login social account
 *
 * @package Easy Digital Download - Social Login
 * @since 1.5.6
 */
function edd_slg_update_social_last_login_timestamp($user_id, $social_type)
{

    if (!empty($user_id) && !empty($social_type))
    { // if user id and social type is not empty
        //get primary account
        $primary_social = get_user_meta($user_id, 'edd_slg_social_user_connect_via', true);

        $timestamp = current_time('timestamp');
        $timestamp_gmt = time();

        if ($primary_social == $social_type)
        { // if $social_type is primary account
            update_user_meta($user_id, 'edd_slg_social_login_timestamp', $timestamp);
            update_user_meta($user_id, 'edd_slg_social_login_timestamp_gmt', $timestamp_gmt);
        }
        else
        { // If $social_type is secondary account
            update_user_meta($user_id, 'edd_slg_social_' . $social_type . '_login_timestamp', $timestamp);
            update_user_meta($user_id, 'edd_slg_social_' . $social_type . '_login_timestamp_gmt', $timestamp_gmt);
        }
    }
}

/**
 * Get Last Login Social Account
 *
 * Handles to get last login social account
 *
 * @package Easy Digital Download - Social Login
 * @since 1.5.6
 */
function edd_slg_get_social_last_login_timestamp($user_id, $social_type, $is_gmt = false)
{

    $social_login_timestamp = array(
        'timestamp' => '',
        'timestamp_gmt' => ''
    );

    if (!empty($user_id) && !empty($social_type))
    { // if user id and social type is not empty
        //get primary account
        $primary_social = get_user_meta($user_id, 'edd_slg_social_user_connect_via', true);

        if ($primary_social == $social_type)
        { // if $social_type is primary account
            $social_login_timestamp['timestamp'] = get_user_meta($user_id, 'edd_slg_social_login_timestamp', true);
            $social_login_timestamp['timestamp_gmt'] = get_user_meta($user_id, 'edd_slg_social_login_timestamp_gmt', true);

        }
        else
        { // If $social_type is secondary account
            $social_login_timestamp['timestamp'] = get_user_meta($user_id, 'edd_slg_social_' . $social_type . '_login_timestamp', true);
            $social_login_timestamp['timestamp_gmt'] = get_user_meta($user_id, 'edd_slg_social_' . $social_type . '_login_timestamp_gmt', true);

        }
    }

    $login_timestamp = ($is_gmt) ? $social_login_timestamp['timestamp_gmt'] : $social_login_timestamp['timestamp'];

    return apply_filters('edd_slg_get_social_last_login_timestamp', $login_timestamp, $user_id, $social_type, $is_gmt);
}

/**
 * Social Login Messages
 *
 * Handles to change social login mesages
 * and links displayed at front side
 *
 @package Easy Digital Download - Social Login
 * @since 1.5.6
 */
function edd_slg_messages()
{

    return apply_filters('edd_slg_messages', array(
        'connected_link_heading' => esc_html__('Your account is connected to the following social login providers.', 'eddslg') ,
        'no_social_connected' => esc_html__('You have no social login profiles connected.', 'eddslg') ,
        'add_more_link' => esc_html__('Add More...', 'eddslg') ,
        'connect_now_link' => esc_html__('Connect one now', 'eddslg') ,
        'account_unlinked_notice' => esc_html__('%s account was successfully unlinked from your account.', 'eddslg') ,
        'already_linked_error' => esc_html__('This account is already linked with another account.', 'eddslg') ,
        'account_exist_error' => esc_html__('This account is already exist', 'eddslg') ,
        'fberrormsg' => esc_html__('Please enter Facebook API Key & Secret in settings page.', 'eddslg') ,
        'gperrormsg' => esc_html__('Please enter Google Client ID & Secret in settings page.', 'eddslg') ,
        'lierrormsg' => esc_html__('Please enter LinkedIn API Key & Secret in settings page.', 'eddslg') ,
        'twerrormsg' => esc_html__('Please enter Twitter Consumer Key & Secret in settings page.', 'eddslg') ,
        'yherrormsg' => esc_html__('Please enter Yahoo API Consumer Key, Secret & App Id in settings page.', 'eddslg') ,
        'fserrormsg' => esc_html__('Please enter Foursquare API Client ID & Secret in settings page.', 'eddslg') ,
        'wlerrormsg' => esc_html__('Please enter Windows Live API Client ID & Secret in settings page.', 'eddslg') ,
        'vkerrormsg' => esc_html__('Please enter VK API Client ID & Secret in settings page.', 'eddslg') ,
        'amazonerrormsg' => esc_html__('Please enter Amazon API Client ID & Secret in settings page.', 'eddslg') ,
        'paypalerrormsg' => esc_html__('Please enter Paypal API Client ID & Secret in settings page.', 'eddslg') ,
        'applerrmsg' => esc_html__('Please enter Apple Client ID  in settings page.', 'eddslg'), 
    ));
}

/**
 * Social link buttons
 *
 * @package  Easy Digital Download - Social Login
 * @since 1.5.6
 */
function edd_slg_link_buttons($redirect_url = '')
{

    global $edd_options;

    $can_show_container = edd_slg_can_show_all_social_link_container();

    $link_button_html = '';

    if ($can_show_container)
    { // can show container
        // get redirect url from settings
        $link_redirect_url = isset($edd_options['edd_slg_redirect_url']) ? $edd_options['edd_slg_redirect_url'] : '';
        $link_redirect_url = !empty($redirect_url) ? $redirect_url : $link_redirect_url; // check redirect url first from shortcode or if checkout page then use cuurent page is redirect url
        ob_start(); ?>
		<p><?php echo esc_html__('You can link your account to the following providers:', 'eddslg'); ?></p>
		<fieldset class="edd-slg-social-container edd-slg-social-wrap edd-slg-social-container-checkout edd-social-link-buttons">
			<input type="hidden" class="edd-slg-redirect-url" id="edd_slg_redirect_url" value="<?php echo $link_redirect_url; ?>" />
			<!-- Display buttons which are not linked--><?php

        do_action('edd_slg_checkout_social_login_link'); ?>
			<div class="edd-slg-login-error"></div>
		</fieldset><?php
        $link_button_html .= ob_get_clean();
    }

    echo apply_filters('edd_slg_link_buttons', $link_button_html);
    wp_enqueue_script('edd-slg-public-script');
}

/**
 * Display Or Not On Thankyou Page
 *
 * Handles to check whether it display on thankyou page or not
 *
 * @package Easy Digital Download - Social Login
 * @since 1.5.6
 */
function edd_slg_link_display_on_thankyou_page()
{

    global $edd_options;

    $enable = false;

    $link_on_thankyou_page = isset($edd_options['edd_slg_display_link_thank_you']) ? $edd_options['edd_slg_display_link_thank_you'] : '';

    if (isset($link_on_thankyou_page) && !empty($link_on_thankyou_page))
    {
        $enable = true;
    }

    return apply_filters('edd_slg_link_display_on_thankyou_page', $enable);
}

/**
 * Display Link Buttons On MyAccount
 *
 * Handles to display link buttons on my account page
 *
 * @package Easy Digital Download - Social Login
 * @since 1.5.6
 */
function edd_slg_login_display_on_myaccount_page()
{

    global $edd_options;

    $enable = false;
    $login_on_myaccount_page = isset($edd_options['edd_slg_enable_edd_login_page']) ? $edd_options['edd_slg_enable_edd_login_page'] : '';

    if (isset($login_on_myaccount_page) && !empty($login_on_myaccount_page))
    {
        $enable = true;
    }

    return apply_filters('edd_slg_login_display_on_myaccount_page', $enable);
}

/**
 * Display custom messages
 *
 * @package Easy Digital Download - Social Login
 * @since 1.5.6
 */
function edd_slg_success_message($message, $display = true)
{

    $message_text = '';

    $message_text .= '<div class="edd_success edd-alert edd-alert-success"><p id="edd_slg_success"><strong>' . esc_html__('Success', 'eddslg') . '</strong> : ';
    $message_text .= $message;
    $message_text .= '</p></div>';

    $message_text = apply_filters('edd_slg_success_message', $message_text);

    if ($display)
    {
        echo $message_text;
    }
    else
    {
        return $message_text;
    }
}

/**
 * Insert value in array
 *
 * Handles to add row in some array after some key
 *
 * @package Easy Digital Download - Social Login
 * @since 1.7.6
 */
function edd_slg_insert_array_after($array, $insert_key, $element)
{

    $new_array = array();

    foreach ($array as $key => $value)
    {

        $new_array[$key] = $value;

        if ($insert_key == $key)
        {

            foreach ($element as $k => $v)
            {
                $new_array[$k] = $v;
            }
        }
    }

    return $new_array;
}

/**
 * Set No cache parameter to the query string
 *
 * @package Easy Digital Download - Social Login
 * @since 2.1.6
 */
function edd_slg_add_no_cache_param($url)
{

    global $edd_options;

    if (!empty($edd_options['edd_slg_enable_caching_resolution']) && !empty($url))
    {

        $url = add_query_arg(array(
            'no-caching' => '1'
        ) , $url);
    }

    return $url;
}

/**
 * Add Custom Add More Field settings
 *
 * Handle to custom add more field settings
 *
 * @package Easy Digital Download - Social Login
 * @since 1.0.0
 */
function edd_addmore_callback($args)
{

    global $edd_options;

    $value = '';
    if (isset($edd_options[$args['id']]))
    {
        $value = $edd_options[$args['id']];
    }

    $edd_slg_social_hooks_class = ($edd_options['edd_slg_social_btn_position'] == 'hook') ? '' : ' edd-slg-hide-section';

    $size = isset($args['size']) && !is_null($args['size']) ? $args['size'] : 'regular';

    $html = '<ul id="custom-hooks-container" class="' . sanitize_html_class($edd_slg_social_hooks_class) . '"><li class="edd-slg-social-btn-custom-hook">';

    if (function_exists('edd_sanitize_key'))
    {

        if (is_array($value) && !empty($value))
        {

            $hooks_count = 1;

            foreach ($value as $data)
            {

                $html .= '<li class="edd-slg-social-btn-custom-hook">';

                $html .= '<input type="text" class="edd-slg-hook ' . " " . sanitize_html_class($args['size']) . '-text" id="edd_settings[' . edd_sanitize_key($args['id']) . ']" name="edd_settings[' . esc_attr($args['id']) . '][]" value="' . esc_attr(stripslashes($data)) . '"/>';

                if ($hooks_count > 1)
                {

                    $html .= '<button class="edd-slg-remove-custom-hook" type="button">X</button>';
                }

                $html .= '</li>';

                $hooks_count++;
            }

        }
        else
        {

            $html .= '<li class="edd-slg-social-btn-custom-hook">';
            $html .= '<input type="text" class="edd-slg-hook ' . " " . sanitize_html_class($args['size']) . '-text" id="edd_settings[' . edd_sanitize_key($args['id']) . ']" name="edd_settings[' . esc_attr($args['id']) . '][]" value="' . esc_attr(stripslashes($value)) . '"/></li>';
        }

        $html .= '</ul>';
        $html .= '<label for="edd_settings[' . edd_sanitize_key($args['id']) . ']"> ' . wp_kses_post($args['desc']) . '</label>';
        $html .= '<button type="button" id="edd-slg-add-custom-hook" class="btn button-primary custom-hook-btn">' . esc_html__('Add more', 'eddslg') . '</button>';

    }
    else
    {

        if (is_array($value) && !empty($value))
        {

            $hooks_count = 1;

            foreach ($value as $data)
            {

                $html .= '<li class="edd-slg-social-btn-custom-hook">';

                $html .= '<input type="text" class="edd-slg-hook ' . " " . $args['size'] . '-text" id="edd_settings[' . $args['id'] . ']" name="edd_settings[' . $args['id'] . '][]" value="' . esc_attr($data) . '"/>';

                if ($hooks_count > 1)
                {

                    $html .= '<button class="edd-slg-remove-custom-hook" type="button">X</button>';
                }

                $html .= '</li>';

                $hooks_count++;
            }

        }
        else
        {

            $html .= '<li class="edd-slg-social-btn-custom-hook">';
            $html .= '<input type="text" class="edd-slg-hook ' . " " . $args['size'] . '-text" id="edd_settings[' . $args['id'] . ']" name="edd_settings[' . $args['id'] . '][]" value="' . esc_attr($value) . '"/> ';
            $html .= '</li>';
        }

        $html .= '</ul>';
        $html .= '<label for="edd_settings[' . $args['id'] . ']"> ' . $args['desc'] . '</label>';
        $html .= '<button type="button" id="edd-slg-add-custom-hook" class="btn button-primary custom-hook-btn">' . esc_html__('Add more', 'eddslg') . '</button>';
    }

    echo $html;
}

